# バッチ設計書 10-Batch API Defaults（v1）

## 概要

本ドキュメントは、Batch API v1リソースのデフォルト値設定ロジックの設計を記述する。

### 本バッチの処理概要

Batch API Defaultsは、Job・CronJobリソースの未指定フィールドにデフォルト値を適用するdefaulting関数群を提供するパッケージである。APIサーバーのAdmission段階でバリデーション前に呼び出される。

**業務上の目的・背景**：ユーザーがJob・CronJobリソースを作成する際、全てのフィールドを明示的に指定する必要がなく、合理的なデフォルト値が自動適用される仕組みが必要である。これにより、ユーザー体験の向上とAPIの後方互換性を実現する。例えば、非並列Jobの場合はCompletionsとParallelismの両方がデフォルトで1に設定される。

**バッチの実行タイミング**：APIサーバーでのリソース作成・更新リクエスト時に、バリデーション前に同期的に実行される。

**主要な処理内容**：
1. SetDefaults_Job: Jobのデフォルト値設定
   - Completions/Parallelism: 両方nil時は両方1
   - Parallelism: nil時は1
   - BackoffLimit: nil時は6（BackoffLimitPerIndex指定時はMaxInt32）
   - CompletionMode: nil時はNonIndexed
   - Suspend: nil時はfalse
   - PodReplacementPolicy: nil時はTerminatingOrFailed（PodFailurePolicy設定時はFailed）
   - ManualSelector: nil時はfalse
   - Labels: テンプレートラベルからのコピー（Labelsが空の場合）
2. SetDefaults_CronJob: CronJobのデフォルト値設定
   - ConcurrencyPolicy: 空時はAllowConcurrent
   - Suspend: nil時はfalse
   - SuccessfulJobsHistoryLimit: nil時は3
   - FailedJobsHistoryLimit: nil時は1
3. SetDefaults_PodFailurePolicyOnPodConditionsPattern: PodFailurePolicyパターンのデフォルト値
   - Status: 空時はConditionTrue

**前後の処理との関連**：Batch API Types（No.8）の型定義に基づくフィールドのデフォルト設定。デフォルト適用後にBatch API Validation（No.9）が実行される。

**影響範囲**：Job・CronJobリソースの全作成・更新APIリクエスト。

## バッチ種別

APIデフォルト値設定（リクエスト時同期処理）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | APIリクエスト毎（同期実行） |
| 実行時刻 | 該当なし |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | Job/CronJobリソースの作成/更新APIリクエスト |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| kube-apiserver起動 | デフォルト設定はkube-apiserver内で実行 |
| Feature Gate | JobPodReplacementPolicy Feature Gateの有効/無効によりPodReplacementPolicyのデフォルト挙動が変わる |

### 実行可否判定

Job/CronJobリソースの作成・更新リクエスト受信時に自動的に実行される。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| obj (Job) | *batchv1.Job | Yes | なし | デフォルト値設定対象のJobオブジェクト |
| obj (CronJob) | *batchv1.CronJob | Yes | なし | デフォルト値設定対象のCronJobオブジェクト |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| APIリクエストボディ | Kubernetes API (batch/v1) | ユーザーが送信したリソース定義 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 変更されたオブジェクト | Go構造体 | デフォルト値が適用されたJob/CronJobオブジェクト（in-place変更） |

### 出力ファイル仕様

ファイル出力はなし。

## 処理フロー

### 処理シーケンス

```
1. SetDefaults_Job
   ├─ Completions == nil && Parallelism == nil → 両方 = 1
   ├─ Parallelism == nil → 1
   ├─ BackoffLimit == nil
   │   ├─ BackoffLimitPerIndex != nil → MaxInt32
   │   └─ else → 6
   ├─ Labels == nil && Template.Labels != nil → Labels = Template.Labels
   ├─ CompletionMode == nil → NonIndexed
   ├─ Suspend == nil → false
   ├─ Feature(JobPodReplacementPolicy) enabled
   │   ├─ PodReplacementPolicy == nil && PodFailurePolicy != nil → Failed
   │   └─ PodReplacementPolicy == nil → TerminatingOrFailed
   └─ ManualSelector == nil → false

2. SetDefaults_CronJob
   ├─ ConcurrencyPolicy == "" → AllowConcurrent
   ├─ Suspend == nil → false
   ├─ SuccessfulJobsHistoryLimit == nil → 3
   └─ FailedJobsHistoryLimit == nil → 1

3. SetDefaults_PodFailurePolicyOnPodConditionsPattern
   └─ Status == "" → ConditionTrue
```

### フローチャート

```mermaid
flowchart TD
    A[APIリクエスト受信] --> B{Job or CronJob?}
    B -->|Job| C[SetDefaults_Job]
    B -->|CronJob| D[SetDefaults_CronJob]
    C --> E[Completions/Parallelismデフォルト]
    E --> F[BackoffLimitデフォルト]
    F --> G[CompletionModeデフォルト]
    G --> H[Suspend/PodReplacementPolicyデフォルト]
    H --> I[ManualSelectorデフォルト]
    D --> J[ConcurrencyPolicyデフォルト]
    J --> K[Suspend/HistoryLimitデフォルト]
    I --> L[バリデーションへ]
    K --> L
```

## データベース操作仕様

### 操作別データベース影響一覧

該当なし（デフォルト設定は純粋なオブジェクト変更であり、データベース操作を行わない）。

### テーブル別操作詳細

該当なし。

## エラー処理

### エラーケース一覧

該当なし（デフォルト設定はエラーを返さない。値の設定のみを行う）。

### リトライ仕様

該当なし。

### 障害時対応

該当なし。

## トランザクション仕様

該当なし。

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | APIリクエスト数に依存 |
| 目標処理時間 | マイクロ秒以内（単純な値設定） |
| メモリ使用量上限 | 入力オブジェクトサイズのみ |

## 排他制御

該当なし（ステートレスなデフォルト値設定処理）。

## ログ出力

該当なし。

## 監視・アラート

該当なし。

## 備考

- ソースコード: `pkg/apis/batch/v1/defaults.go`
- addDefaultingFuncsでRegisterDefaultsをスキームに登録
- Feature Gate依存: `features.JobPodReplacementPolicy`
- デフォルト値一覧:
  - Job.Spec.Completions: 1（Parallelismもnilの場合）
  - Job.Spec.Parallelism: 1
  - Job.Spec.BackoffLimit: 6（BackoffLimitPerIndex未設定時）/ MaxInt32（BackoffLimitPerIndex設定時）
  - Job.Spec.CompletionMode: NonIndexed
  - Job.Spec.Suspend: false
  - Job.Spec.PodReplacementPolicy: TerminatingOrFailed（PodFailurePolicy未設定時）/ Failed（PodFailurePolicy設定時）
  - Job.Spec.ManualSelector: false
  - CronJob.Spec.ConcurrencyPolicy: AllowConcurrent
  - CronJob.Spec.Suspend: false
  - CronJob.Spec.SuccessfulJobsHistoryLimit: 3
  - CronJob.Spec.FailedJobsHistoryLimit: 1
  - PodFailurePolicyOnPodConditionsPattern.Status: ConditionTrue
